/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.ganja;

import de.gaalop.StringList;
import de.gaalop.ganja.OutputMode;
import java.util.HashMap;
import java.util.HashSet;

public class BlockStringBuilder {
    public StringBuilder current = null;
    private HashMap<String, StringBuilder> blocks = new HashMap();
    public StringList blockorder = new StringList();
    private StringList renderList = new StringList();
    private StringList cenList = new StringList();
    private String graphOptions = "{}";
    private String sliders;
    public HashSet<String> storeResultNodes = new HashSet();
    public String initializeOutputNullVars;
    public String renderListWithoutColors;

    public void entryBlock(String caption) {
        this.current = new StringBuilder();
        this.blocks.put(caption, this.current);
        this.blockorder.add((Object)caption);
    }

    public StringBuilder appendO(char c) {
        return this.current.append(c);
    }

    public StringBuilder appendO(String str) {
        return this.current.append(str);
    }

    public StringBuilder getCurrent() {
        return this.current;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String block : this.blockorder) {
            result.append((CharSequence)this.blocks.get(block));
        }
        return result.toString();
    }

    public String getCode(OutputMode outputMode) {
        switch (outputMode) {
            case COFFEESHOP: {
                return this.createCodeForCoffeeshop();
            }
            case GAALOPWEB: {
                return this.createCodeForGAALOPWeb();
            }
            case JUPYTER_NOTEBOOK: {
                return this.createCodeForJupyterNotebook();
            }
        }
        return this.createCodeForStandalonePage();
    }

    public void printDebugCode() {
        for (String block : this.blockorder) {
            System.out.println("// ============== BLOCK " + block + " =================");
            System.out.println(this.blocks.get(block).toString());
        }
    }

    public void setRenderList(StringList renderList) {
        this.renderList = renderList;
    }

    public void setCenList(StringList cenList) {
        this.cenList = cenList;
    }

    private String createCodeForCoffeeshop() {
        StringBuilder result = new StringBuilder();
        result.append((CharSequence)this.blocks.get("Begin Algebra"));
        result.append((CharSequence)this.blocks.get("Define calculate"));
        result.append((CharSequence)this.blocks.get("Set RenderList"));
        result.append("var input_values = [" + this.cenList.join() + "];\n");
        result.append("var canvas = this.graph(()=>{\n");
        result.append("   return calculate(...input_values);\n");
        result.append("}," + this.graphOptions + ");\n");
        result.append("document.body.appendChild(canvas);\n");
        result.append((CharSequence)this.blocks.get("End Algebra"));
        return result.toString();
    }

    private String createCodeForGAALOPWeb() {
        StringBuilder result = new StringBuilder();
        for (String block : this.blockorder) {
            result.append((CharSequence)this.blocks.get(block));
        }
        return result.toString();
    }

    private String createCodeForJupyterNotebook() {
        StringBuilder result = new StringBuilder();
        result.append((CharSequence)this.blocks.get("Begin Algebra"));
        result.append((CharSequence)this.blocks.get("Define calculate"));
        result.append((CharSequence)this.blocks.get("Set RenderList"));
        result.append("var input_values = [" + this.cenList.join() + "];\n");
        result.append("return this.graph(()=>{\n");
        result.append("   return calculate(...input_values);\n");
        result.append("}," + this.graphOptions + ");\n");
        result.append((CharSequence)this.blocks.get("End Algebra"));
        return result.toString();
    }

    private String createCodeForStandalonePage() {
        StringBuilder result = new StringBuilder();
        result.append("<!DOCTYPE html>\n<html>\n    <head>\n        <meta charset=\"utf-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <script src=\"https://gaalopweb.esa.informatik.tu-darmstadt.de/gaalopweb/lib/ganja/ganja.js\"></script>\n        <style>\n            body {\n                display: flex;\n                flex: 1;\n                flex-direction: column;\n                justify-content: flex-start;\n                align-items: stretch;\n                min-height: 98vh;\n                background-color: rgb(176,232,255);\n                color: rgb(17,20,173);\n            }\n            .vispanel {\n                display: flex;\n                flex-direction: row;\n                justify-content: flex-start;\n                align-items: flex-start;\n            }\n            #sliderpanel {\n                display: flex;\n                flex-direction: column;\n                justify-content: flex-start;\n                align-items: flex-start;\n            }\n            .slideritem {\n                display: flex;\n                flex-direction: row;\n                justify-content: center;\n                align-items: center;\n            }\n        </style>\n    </head>\n    <body>\n        <a>Visualization (Based on ganja.js):</a>\n        <div class=\"vispanel\">\n            <div id=\"ganjacanvas\"></div>\n            <div id=\"sliderpanel\"></div>\n        </div>\n        <script>\n");
        result.append(this.createCodeForGAALOPWeb());
        result.append("\n        </script>\n    </body>\n</html>\n");
        return result.toString();
    }

    public String getGraphOptions() {
        return this.graphOptions;
    }

    public void setGraphOptions(String graphOptions) {
        this.graphOptions = graphOptions;
    }

    public void setSliders(String sliders) {
        this.sliders = sliders;
    }
}

