/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.ganja;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.ganja.AlgebraProperties;
import de.gaalop.ganja.GanjaExpressionVisitor;
import de.gaalop.ganja.GanjaVisitor;
import java.util.LinkedList;

public class FlatGanjaVisitor
extends GanjaVisitor {
    public FlatGanjaVisitor(AlgebraProperties algebraProperties) {
        super(algebraProperties);
    }

    public void visit(AssignmentNode node) {
        String varName = node.getVariable().getName();
        if (!this.mvs.contains(varName)) {
            this.appendI("var " + varName + " = new Element();\n");
            this.mvs.add(varName);
        }
        this.appendI("");
        node.getVariable().accept((ExpressionVisitor)new GanjaExpressionVisitor(this.code.current));
        this.code.appendO(" = ");
        node.getValue().accept((ExpressionVisitor)new GanjaExpressionVisitor(this.code.current));
        this.code.appendO(";");
        if (node.getVariable() instanceof MultivectorComponent) {
            this.code.appendO(" // ");
            MultivectorComponent component = (MultivectorComponent)node.getVariable();
            this.code.appendO(this.graph.getBladeString(component));
            if (!this.mvComponents.containsKey(component.getName())) {
                this.mvComponents.put(component.getName(), new LinkedList());
            }
            ((LinkedList)this.mvComponents.get(component.getName())).add(component.getBladeIndex());
        }
        this.code.appendO('\n');
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
        this.computeInitializeOutputNullVars();
        this.computeRenderListWithoutColors();
        this.addBlocks();
    }
}

