/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.ganja;

import de.gaalop.CodeGeneratorException;
import de.gaalop.DefaultCodeGenerator;
import de.gaalop.OutputFile;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.ganja.AlgebraProperties;
import de.gaalop.ganja.FlatGanjaVisitor;
import de.gaalop.ganja.GanjaVisitor;
import de.gaalop.ganja.GradedGanjaVisitor;
import de.gaalop.ganja.OutputMode;
import de.gaalop.ganja.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class GanjaCodeGenerator
extends DefaultCodeGenerator {
    private final Plugin plugin;
    private OutputMode outputMode;

    GanjaCodeGenerator(Plugin plugin, OutputMode outputMode) {
        super(outputMode == OutputMode.STANDALONE_PAGE ? "html" : "js");
        this.plugin = plugin;
        this.outputMode = outputMode;
    }

    public Set<OutputFile> generate(ControlFlowGraph graph) throws CodeGeneratorException {
        String code = this.generateCode(graph);
        String filename = this.generateFilename(graph);
        HashSet<OutputFile> result = new HashSet<OutputFile>();
        result.add(new OutputFile(filename, code, Charset.forName("UTF-8")));
        if (this.outputMode == OutputMode.STANDALONE_PAGE) {
            try {
                result.add(new OutputFile("ganja.js", IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("ganja.js"), (Charset)Charset.forName("UTF-8")), Charset.forName("UTF-8")));
            }
            catch (IOException ex) {
                throw new CodeGeneratorException(graph, "ganja.js not readable", (Throwable)ex);
            }
        }
        return result;
    }

    protected String generateCode(ControlFlowGraph graph) {
        try {
            return GanjaCodeGenerator.generateCodeStatic(graph, this.outputMode);
        }
        catch (Throwable error) {
            this.plugin.notifyError(error);
            return "";
        }
    }

    public static String generateCodeStatic(ControlFlowGraph graph, OutputMode outputMode) {
        AlgebraProperties properties = AlgebraProperties.fromSignature(graph.getAlgebraDefinitionFile().getSignature());
        GanjaVisitor visitor = properties.signature.getDimension() >= 7 ? new GradedGanjaVisitor(properties) : new FlatGanjaVisitor(properties);
        graph.accept((ControlFlowVisitor)visitor);
        return visitor.getCode(outputMode);
    }
}

