/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.ganja;

import de.gaalop.OperatorPriority;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;

public class GanjaExpressionVisitor
implements ExpressionVisitor {
    private final OperatorPriority operatorPriority = new OperatorPriority();
    private final StringBuilder code;

    public GanjaExpressionVisitor(StringBuilder code) {
        this.code = code;
    }

    protected void addBinaryInfix(BinaryOperation op, String operator) {
        this.addChild((Expression)op, op.getLeft());
        this.code.append(operator);
        this.addChild((Expression)op, op.getRight());
    }

    protected void addChild(Expression parent, Expression child) {
        if (this.operatorPriority.hasLowerPriority(parent, child)) {
            this.code.append('(');
            child.accept((ExpressionVisitor)this);
            this.code.append(')');
        } else {
            child.accept((ExpressionVisitor)this);
        }
    }

    public void visit(FloatConstant floatConstant) {
        this.code.append(Double.toString(floatConstant.getValue()));
    }

    public void visit(Negation negation) {
        this.code.append('(');
        this.code.append('-');
        this.addChild((Expression)negation, negation.getOperand());
        this.code.append(')');
    }

    public void visit(LogicalOr node) {
        this.addBinaryInfix((BinaryOperation)node, " || ");
    }

    public void visit(LogicalAnd node) {
        this.addBinaryInfix((BinaryOperation)node, " && ");
    }

    public void visit(LogicalNegation node) {
        this.code.append('!');
        this.addChild((Expression)node, node.getOperand());
    }

    public void visit(Equality node) {
        this.addBinaryInfix((BinaryOperation)node, " == ");
    }

    public void visit(Inequality node) {
        this.addBinaryInfix((BinaryOperation)node, " != ");
    }

    public void visit(Relation relation) {
        this.addBinaryInfix((BinaryOperation)relation, relation.getTypeString());
    }

    public void visit(Subtraction subtraction) {
        this.addBinaryInfix((BinaryOperation)subtraction, " - ");
    }

    public void visit(Addition addition) {
        this.addBinaryInfix((BinaryOperation)addition, " + ");
    }

    public void visit(Division division) {
        this.addBinaryInfix((BinaryOperation)division, " / ");
    }

    public void visit(Multiplication multiplication) {
        this.addBinaryInfix((BinaryOperation)multiplication, " * ");
    }

    public void visit(MathFunctionCall mathFunctionCall) {
        this.code.append("Math." + mathFunctionCall.getFunction().toString().toLowerCase());
        this.code.append('(');
        mathFunctionCall.getOperand().accept((ExpressionVisitor)this);
        this.code.append(')');
    }

    public void visit(Variable variable) {
        this.code.append(variable.getName());
    }

    public void visit(MultivectorComponent component) {
        this.code.append(component.getName());
        this.code.append("[" + component.getBladeIndex() + "]");
    }

    public void visit(Exponentiation exponentiation) {
        if (this.isSquare(exponentiation)) {
            Multiplication m = new Multiplication(exponentiation.getLeft(), exponentiation.getLeft());
            m.accept((ExpressionVisitor)this);
        } else {
            this.code.append("Math.pow(");
            exponentiation.getLeft().accept((ExpressionVisitor)this);
            this.code.append(',');
            exponentiation.getRight().accept((ExpressionVisitor)this);
            this.code.append(')');
        }
    }

    protected boolean isSquare(Exponentiation exponentiation) {
        FloatConstant two = new FloatConstant(2.0);
        return two.equals((Object)exponentiation.getRight());
    }

    public void visit(Reverse node) {
        throw new UnsupportedOperationException("The Ganja backend does not support the reverse operation.");
    }

    public void visit(OuterProduct outerProduct) {
        throw new UnsupportedOperationException("The Ganja backend does not support the outer product.");
    }

    public void visit(BaseVector baseVector) {
        throw new UnsupportedOperationException("The Ganja backend does not support base vectors.");
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException("Macros should have been inlined and no function arguments should be the graph.");
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException("Macro " + node.getName() + " should have been inlined and no macro calls should be in the graph.");
    }

    public void visit(InnerProduct innerProduct) {
        throw new UnsupportedOperationException("The MATLAB backend does not support the inner product.");
    }
}

