/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.ganja;

import de.gaalop.StringList;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.Variable;
import de.gaalop.ganja.AlgebraProperties;
import de.gaalop.ganja.BlockStringBuilder;
import de.gaalop.ganja.GradedGanjaVisitor;
import de.gaalop.ganja.OutputMode;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GanjaVisitor
implements ControlFlowVisitor {
    protected Log log = LogFactory.getLog(GradedGanjaVisitor.class);
    protected AlgebraProperties algebraProperties;
    protected HashSet<String> mvs = new HashSet();
    protected ControlFlowGraph graph = null;
    protected HashMap<String, LinkedList<Integer>> mvComponents = new HashMap();
    protected HashMap<String, Color> expressionStatements = new HashMap();
    protected Color curColor = Color.black;
    protected int indentation = 0;
    protected String varTimeName = "TIME";
    protected String timeStartName = "__sysTimeStart";
    protected String currentTimeName = "__currSysTime";
    protected BlockStringBuilder code = new BlockStringBuilder();

    public GanjaVisitor(AlgebraProperties algebraProperties) {
        this.algebraProperties = algebraProperties;
    }

    public String getCode(OutputMode outputMode) {
        return this.code.getCode(outputMode);
    }

    public void printDebugCode() {
        this.code.printDebugCode();
    }

    protected void appendIndentation() {
        for (int i = 0; i < this.indentation; ++i) {
            this.code.appendO('\t');
        }
    }

    public StringBuilder appendI(char c) {
        this.appendIndentation();
        return this.code.appendO(c);
    }

    public StringBuilder appendI(String str) {
        this.appendIndentation();
        return this.code.appendO(str);
    }

    public void visit(StoreResultNode node) {
        this.code.storeResultNodes.add(node.getValue().toString());
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        this.expressionStatements.put(((Variable)node.getExpression()).getName(), new Color(this.curColor.getRed(), this.curColor.getGreen(), this.curColor.getBlue(), this.curColor.getAlpha()));
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StartNode node) {
        this.graph = node.getGraph();
        this.code.entryBlock("Begin Algebra");
        this.appendI(this.algebraProperties.getAlgebraHeader());
        ++this.indentation;
        this.appendI(this.algebraProperties.getExtraBasisVectors());
        this.appendI(this.algebraProperties.getUp());
        this.code.entryBlock("Define FunctionToSliders");
        StringList inputParametersStrList = this.addFunctionToSliders();
        this.code.entryBlock("Define calculate");
        this.appendI("let " + this.varTimeName + "= 0;\n");
        this.appendI("let " + this.timeStartName + " = performance.now();\n");
        this.appendI("function calculate(" + inputParametersStrList.join() + ") {\n");
        ++this.indentation;
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ColorNode node) {
        this.curColor = new Color((float)((FloatConstant)node.getR()).getValue(), (float)((FloatConstant)node.getG()).getValue(), (float)((FloatConstant)node.getB()).getValue(), (float)((FloatConstant)node.getAlpha()).getValue());
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    protected StringList addFunctionToSliders() {
        StringList inputParametersStrList = new StringList();
        StringList argsList = new StringList();
        StringList minList = new StringList();
        StringList maxList = new StringList();
        StringList stepList = new StringList();
        StringList cenList = new StringList();
        for (String var : this.graph.getInputs()) {
            if (!(var.equals(this.varTimeName) || var.equals(this.timeStartName) || var.equals(this.currentTimeName))) {
                inputParametersStrList.add((Object)var);
                argsList.add((Object)("\"" + var + "= \""));
            }
            String min = this.graph.getPragmaMinValue().getOrDefault(var, "0");
            String max = this.graph.getPragmaMaxValue().getOrDefault(var, "1");
            String def = Double.toString((Double.parseDouble(max) - Double.parseDouble(min)) / 100.0);
            minList.add((Object)min);
            maxList.add((Object)max);
            cenList.add((Object)Double.toString((Double.parseDouble(min) + Double.parseDouble(max)) / 2.0));
            stepList.add((Object)def);
        }
        this.code.setCenList(cenList);
        String sliders = "    var f_args = [" + argsList.join() + "];\n    var min_list = [" + minList.join() + "];\n    var max_list = [" + maxList.join() + "];\n    var step_list = [" + stepList.join() + "];\n    var cen_list = [" + cenList.join() + "];\n";
        this.code.setSliders(sliders);
        this.code.appendO("  var function_to_sliders = f=>{\n" + sliders + "    window.sliderValues = cen_list.slice(0);\n    var sliderValueTextElements = cen_list.slice(0);\n    for (let i=0; i<f.length; i++) {\n      var slideritem = document.createElement('div');\n      slideritem.setAttribute(\"class\", \"slideritem\");\n      document.getElementById(\"sliderpanel\").appendChild(slideritem);\n      var slidername = document.createElement('a');\n      slidername.appendChild(document.createTextNode('['+min_list[i]+','+max_list[i]+']'));\n      slideritem.appendChild(slidername);\n      var slider = Object.assign(document.createElement('input'),{type:'range',min:min_list[i],max:max_list[i],step:step_list[i],value:cen_list[i]});\n      slider.oninput = function(){sliderValueTextElements[i].innerHTML=this.value; window.sliderValues[i]=+this.value};\n      slideritem.appendChild(slider);\n      var slidername = document.createElement('a');\n      slidername.appendChild(document.createTextNode(f_args[i]));\n      slideritem.appendChild(slidername);\n      sliderValueTextElements[i] = document.createElement('a');\n      sliderValueTextElements[i].innerHTML = cen_list[i];\n      slideritem.appendChild(sliderValueTextElements[i]);\n    }\n  }\n  \n");
        return inputParametersStrList;
    }

    protected void computeInitializeOutputNullVars() {
        StringBuilder sb = new StringBuilder();
        for (String mv : this.code.storeResultNodes) {
            if (this.mvs.contains(mv)) continue;
            sb.append("var " + mv + " = new Element();\n");
        }
        this.code.initializeOutputNullVars = sb.toString();
    }

    protected void computeRenderListWithoutColors() {
        StringBuilder sb = new StringBuilder();
        StringList renderList = new StringList();
        for (String mv : new StringList(this.code.storeResultNodes).sortIgnoringCase()) {
            renderList.add((Object)mv);
            renderList.add((Object)("\"" + mv + "\""));
        }
        sb.append("return [" + renderList.join() + "];\n");
        this.code.renderListWithoutColors = sb.toString();
    }

    protected void addBlocks() {
        Color c;
        this.code.entryBlock("Set RenderList");
        StringList renderList = new StringList();
        for (String mv : new StringList(this.expressionStatements.keySet()).sortIgnoringCase()) {
            c = this.expressionStatements.get(mv);
            renderList.add((Object)("0x" + String.format("%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue())));
            renderList.add((Object)mv);
            renderList.add((Object)("\"" + mv + "\""));
        }
        for (String[] segment : this.graph.drawSegments) {
            if (segment.length != 2) continue;
            c = this.expressionStatements.get(segment[0]);
            renderList.add((Object)("0x" + String.format("%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue())));
            renderList.add((Object)("[" + segment[0] + "," + segment[1] + "]"));
            renderList.add((Object)"\"\"");
        }
        for (String[] triangle : this.graph.drawTriangles) {
            if (triangle.length != 3) continue;
            c = this.expressionStatements.get(triangle[0]);
            renderList.add((Object)("0x" + String.format("%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue())));
            renderList.add((Object)("[" + triangle[0] + "," + triangle[1] + "," + triangle[2] + "]"));
            renderList.add((Object)"\"\"");
        }
        this.code.setRenderList(renderList);
        this.appendI("return [" + renderList.join() + "];\n");
        --this.indentation;
        this.appendI("}\n");
        this.code.entryBlock("Call Function to Sliders");
        this.appendI("function_to_sliders(calculate);\n\n");
        this.code.entryBlock("Call Graph");
        StringList options = new StringList();
        options.add((Object)("conformal:" + Boolean.toString(this.algebraProperties.isConformal())));
        options.add((Object)("gl:" + Boolean.toString(this.algebraProperties.isGL())));
        options.add((Object)"animate: true");
        options.add((Object)"ipns:true");
        options.add((Object)"noZ:true");
        options.add((Object)"grid:true");
        options.add((Object)"labels:true");
        options.add((Object)"thresh:0.05");
        options.add((Object)"lineWidth: 2");
        if (!this.algebraProperties.getUp().equals("")) {
            if (this.algebraProperties.getRenderingDimensions() == 2) {
                options.add((Object)"up:up(Element.Scalar(\"x\"),Element.Scalar(\"y\")).Vector.map(x=>x.replace(new RegExp(\"-1\",\"g\"),\"-1.0\"))");
            } else {
                options.add((Object)"up:up(Element.Scalar(\"x\"),Element.Scalar(\"y\"),Element.Scalar(\"z\")).Vector");
            }
        }
        this.code.setGraphOptions("{ " + options.join() + " }");
        this.appendI("var canvas = this.graph(()=> { \nlet " + this.currentTimeName + " = performance.now();\n" + this.varTimeName + " = (" + this.currentTimeName + " - " + this.timeStartName + ") / 1000;\nreturn [\n   ...calculate(...sliderValues)\n]}, " + this.code.getGraphOptions() + ");\n");
        this.code.entryBlock("Set canvas options");
        this.appendI("canvas.style.width = '49vw';\n");
        this.appendI("canvas.style.height = '50vh';\n");
        this.code.entryBlock("Add canvas");
        this.appendI("document.getElementById(\"ganjacanvas\").appendChild(canvas);\n");
        this.code.entryBlock("End Algebra");
        --this.indentation;
        this.appendI("});");
    }

    public void visit(IfThenElseNode node) {
        throw new IllegalStateException("IfThenElseNodes are not supported anymore.");
    }

    public void visit(LoopNode node) {
        throw new IllegalStateException("LoopNode are not supported anymore.");
    }

    public void visit(BreakNode breakNode) {
        throw new IllegalStateException("BreakNode are not supported anymore.");
    }

    public void visit(BlockEndNode node) {
        throw new IllegalStateException("BlockEndNode are not supported anymore.");
    }

    public void visit(Macro node) {
        throw new IllegalStateException("Macros should have been inlined and removed from the graph.");
    }
}

