/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.ganja;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.ganja.AlgebraProperties;
import de.gaalop.ganja.GanjaExpressionVisitor;
import de.gaalop.ganja.GanjaVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;

public class GradedGanjaVisitor
extends GanjaVisitor {
    private String curVar = "";
    private HashMap<Integer, LinkedList<NodeWithGradedIndex>> mapGraded = new HashMap();

    public GradedGanjaVisitor(AlgebraProperties algebraProperties) {
        super(algebraProperties);
    }

    public void visit(AssignmentNode node) {
        String varName = node.getVariable().getName();
        if (!this.mvs.contains(varName)) {
            this.printCollectedAssignments();
            this.mapGraded.clear();
            this.curVar = varName;
            this.mvs.add(varName);
        }
        if (node.getVariable() instanceof MultivectorComponent) {
            MultivectorComponent mvc = (MultivectorComponent)node.getVariable();
            GradedIndex gradedIndex = this.getGradedIndexFromBladeIndex(mvc.getBladeIndex());
            if (!this.mapGraded.containsKey(gradedIndex.i)) {
                this.mapGraded.put(gradedIndex.i, new LinkedList());
            }
            this.mapGraded.get(gradedIndex.i).add(new NodeWithGradedIndex(gradedIndex, node));
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
        this.computeInitializeOutputNullVars();
        this.computeRenderListWithoutColors();
        this.printCollectedAssignments();
        this.curVar = "";
        this.addBlocks();
    }

    private static Long factorial(int n) {
        if (n <= 1) {
            return 1L;
        }
        Long result = 2L;
        for (int i = 3; i <= n; ++i) {
            result = result * (long)i;
        }
        return result;
    }

    private static long binomialCoefficient(int n, int k) {
        return GradedGanjaVisitor.factorial(n) / (GradedGanjaVisitor.factorial(k) * GradedGanjaVisitor.factorial(n - k));
    }

    private GradedIndex getGradedIndexFromBladeIndex(int bladeIndex) {
        int i = 0;
        int n = this.algebraProperties.signature.getDimension();
        int rest = bladeIndex;
        Long bladeCountInGrade = 1L;
        while ((long)rest >= bladeCountInGrade) {
            rest = (int)((long)rest - bladeCountInGrade);
            bladeCountInGrade = GradedGanjaVisitor.binomialCoefficient(n, ++i);
        }
        return new GradedIndex(i, rest);
    }

    private void printCollectedAssignments() {
        if (this.mapGraded.isEmpty()) {
            return;
        }
        int n = this.algebraProperties.signature.getDimension();
        this.appendI("var " + this.curVar + " = new Element();\n");
        ArrayList<Integer> grades = new ArrayList<Integer>(this.mapGraded.keySet());
        grades.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return Integer.compare(i1, i2);
            }
        });
        for (Integer grade : grades) {
            Object[] positions = new String[(int)GradedGanjaVisitor.binomialCoefficient(n, grade)];
            Arrays.fill(positions, "0");
            for (NodeWithGradedIndex node : this.mapGraded.get(grade)) {
                StringBuilder expressionCode = new StringBuilder();
                node.node.getValue().accept((ExpressionVisitor)new GanjaExpressionVisitor(expressionCode));
                positions[node.gradedIndex.j] = expressionCode.toString();
            }
            this.appendI(this.curVar + "[" + grade + "] = [" + String.join((CharSequence)",", (CharSequence[])positions) + "];\n");
        }
    }

    private class GradedIndex {
        public int i;
        public int j;

        public GradedIndex(int i, int j) {
            this.i = i;
            this.j = j;
        }
    }

    private class NodeWithGradedIndex {
        public GradedIndex gradedIndex;
        public AssignmentNode node;

        public NodeWithGradedIndex(GradedIndex gradedIndex, AssignmentNode node) {
            this.gradedIndex = gradedIndex;
            this.node = node;
        }
    }
}

