/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.clucalc.input;

import de.gaalop.CodeParser;
import de.gaalop.CodeParserException;
import de.gaalop.InputFile;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ReturnDefinition;
import de.gaalop.clucalc.input.CluCalcLexer;
import de.gaalop.clucalc.input.CluCalcParser;
import de.gaalop.clucalc.input.CluVisitor;
import de.gaalop.clucalc.input.Plugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum CluCalcCodeParser implements CodeParser
{
    INSTANCE;

    final String DEFAULT_PRAGMA_START = "//#pragma ";
    final String SHORT_PRAGMA_START = "#pragma ";
    private static final Log log;
    private Plugin plugin;

    public void setPluginReference(Plugin plugin) {
        if (this.plugin == null) {
            this.plugin = plugin;
        }
    }

    public ControlFlowGraph parseFile(InputFile input) throws CodeParserException {
        ControlFlowGraph graph;
        log.debug((Object)("Processing " + input.getName() + ", Content: \n" + input.getContent()));
        try {
            graph = this.parse(input);
        }
        catch (Throwable e) {
            throw new CodeParserException(input, e.getMessage(), e);
        }
        graph.setSource(input);
        return graph;
    }

    /*
     * WARNING - void declaration
     */
    private ControlFlowGraph parse(InputFile input) throws CodeParserException, IOException {
        LinkedList<String> onlyEvaluates = new LinkedList<String>();
        LinkedList<String> outputs = new LinkedList<String>();
        LinkedList<String[]> drawSegments = new LinkedList<String[]>();
        LinkedList<String[]> drawTriangles = new LinkedList<String[]>();
        String syntax = null;
        LinkedList<String> ranges = new LinkedList<String>();
        LinkedList<ReturnDefinition> returnDefinitions = new LinkedList<ReturnDefinition>();
        LinkedList<String> insertionTexts = new LinkedList<String>();
        Boolean usingNormalizePragma = false;
        String content = input.getContent();
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String line = null;
        StringBuilder builder = new StringBuilder();
        block22: while ((line = reader.readLine()) != null) {
            Pattern pattern;
            Matcher matcher;
            String trimmedLine = line.trim();
            Boolean usingPragma = trimmedLine.startsWith("//#pragma ");
            Boolean usingNewPragma = trimmedLine.startsWith("#pragma ");
            if (usingPragma.booleanValue() || usingNewPragma.booleanValue()) {
                String whichPragma;
                int lengthOfPragmaStart = usingNewPragma != false ? "#pragma ".length() : "//#pragma ".length();
                String line2 = line.replaceAll("\t", " ");
                while (line2.contains("  ")) {
                    line2 = line2.replaceAll("  ", " ");
                }
                int indexOfSpace = line2.indexOf(" ", 10);
                Boolean restIsMissing = indexOfSpace == -1;
                String string = whichPragma = restIsMissing != false ? line2.substring(lengthOfPragmaStart) : line2.substring(lengthOfPragmaStart, indexOfSpace);
                if (whichPragma.equals("unroll") || whichPragma.equals("count")) {
                    builder.append(line);
                    builder.append("\n");
                    continue;
                }
                String string2 = restIsMissing != false ? "" : line2.substring(indexOfSpace + 1);
                switch (whichPragma) {
                    case "output": {
                        String[] partsOutput = string2.split(" ");
                        for (int i = 1; i < partsOutput.length; ++i) {
                            outputs.add(partsOutput[0] + " " + partsOutput[i]);
                        }
                        continue block22;
                    }
                    case "onlyEvaluate": {
                        String[] partsOnlyEvaluate = string2.split(" ");
                        onlyEvaluates.addAll(Arrays.asList(partsOnlyEvaluate));
                        break;
                    }
                    case "in2out": {
                        syntax = string2;
                        break;
                    }
                    case "segments": {
                        void var23_29;
                        while (var23_29.contains("  ")) {
                            String string3 = var23_29.replaceAll("\\W\\W", " ");
                        }
                        for (String t : var23_29.split(",")) {
                            String[] segmentMvs = t.trim().split("\\W");
                            if (segmentMvs.length != 2) {
                                throw new CodeParserException(input, "pragma segments must be in format: A1 B1, A2 B2, ... , An Bn.");
                            }
                            drawSegments.add(segmentMvs);
                        }
                        continue block22;
                    }
                    case "triangles": {
                        void var23_31;
                        while (var23_31.contains("  ")) {
                            String string4 = var23_31.replaceAll("\\W\\W", " ");
                        }
                        for (String t : var23_31.split(",")) {
                            String[] triangleMvs = t.trim().split("\\W");
                            if (triangleMvs.length != 3) {
                                throw new CodeParserException(input, "pragma triangles must be in format: A1 B1 C1, A2 B2 C2, ... , An Bn Cn.");
                            }
                            drawTriangles.add(triangleMvs);
                        }
                        continue block22;
                    }
                    case "range": {
                        ranges.add(string2);
                        break;
                    }
                    case "insert": {
                        insertionTexts.add(string2);
                        break;
                    }
                    case "return": {
                        String[] parts = string2.split("\\s+typed\\s+|\\s+as\\s+");
                        if (parts.length != 3) continue block22;
                        String variablesText = parts[0];
                        String returnType = parts[1];
                        String returnText = parts[2];
                        String[] variables = (String[])Arrays.stream(variablesText.split(",")).map(String::trim).toArray(String[]::new);
                        ReturnDefinition returnDefintion = new ReturnDefinition(variables, returnType, returnText);
                        returnDefinitions.add(returnDefintion);
                        break;
                    }
                    case "normalize": {
                        usingNormalizePragma = true;
                        break;
                    }
                    default: {
                        throw new CodeParserException(input, "pragma " + whichPragma + " is unknown.");
                    }
                }
                continue;
            }
            if (usingNormalizePragma.booleanValue() && !line.startsWith("//") && (matcher = (pattern = Pattern.compile("\\?(\\w+)\\s*=\\s*(.+)")).matcher(line)).find()) {
                String variable = matcher.group(1);
                String expression = matcher.group(2);
                String variableUnnormalized = variable + "_unnormalized";
                builder.append((String)variableUnnormalized + " = " + expression);
                builder.append("\n");
                builder.append("?" + variable + " = " + (String)variableUnnormalized + " / abs(" + (String)variableUnnormalized + ")");
                builder.append("\n");
                continue;
            }
            builder.append(line);
            builder.append("\n");
        }
        String program = builder.toString();
        ANTLRInputStream inputStream = new ANTLRInputStream((Reader)new StringReader(program));
        CluCalcLexer lexer = new CluCalcLexer((CharStream)inputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        CluCalcParser parser = new CluCalcParser((TokenStream)tokenStream);
        CluVisitor visitor = new CluVisitor();
        visitor.visit((ParseTree)parser.script());
        ControlFlowGraph graph = visitor.graph;
        for (ReturnDefinition returnDefinition : returnDefinitions) {
            graph.addReturnDefinition(returnDefinition);
        }
        for (String string : insertionTexts) {
            graph.addInsertionText(string);
        }
        graph.drawSegments = drawSegments;
        graph.drawTriangles = drawTriangles;
        if (syntax != null) {
            String[] syntaxParts = syntax.split("->");
            if (syntaxParts.length == 2) {
                for (String var : syntaxParts[0].split(",")) {
                    graph.syntaxInputs.add((Object)var.trim());
                }
                for (String var : syntaxParts[1].split(",")) {
                    graph.syntaxOutputs.add((Object)var.trim());
                }
            } else {
                throw new CodeParserException(input, "#pragma in2out must contain one arrow ->");
            }
            graph.syntaxSpecified = true;
        } else {
            graph.syntaxSpecified = false;
        }
        for (String string : outputs) {
            graph.getPragmaOutputVariables().add(string);
        }
        for (String string : onlyEvaluates) {
            graph.addPragmaOnlyEvaluateVariable(string);
        }
        for (String string : ranges) {
            String[] rangeParts = string.split("<=");
            if (rangeParts.length == 3) {
                graph.addPragmaMinMaxValues(rangeParts[1].trim(), rangeParts[0].trim(), rangeParts[2].trim());
                continue;
            }
            throw new CodeParserException(input, "#pragma range must be of the form: {minValue} <= {variable_name} <= {maxValue} but is " + string);
        }
        return graph;
    }

    static {
        log = LogFactory.getLog(CluCalcCodeParser.class);
    }
}

