/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.clucalc.input;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.clucalc.input.CluCalcBaseVisitor;
import de.gaalop.clucalc.input.CluCalcParser;
import de.gaalop.clucalc.input.GraphBuilder;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class CluVisitor
extends CluCalcBaseVisitor<Object> {
    public ControlFlowGraph graph;
    private ArrayList<SequentialNode> nodes;
    private GraphBuilder graphBuilder;
    private int inIfBlock = 0;
    private boolean inMacro = false;
    private List<String> errors = new ArrayList<String>();
    private LinkedList<SequentialNode> macroNodes;

    @Override
    public Object visitEvaluateAssignmentCase(CluCalcParser.EvaluateAssignmentCaseContext ctx) {
        AssignmentNode node = (AssignmentNode)this.visitAssignment(ctx.val);
        this.graph.addPragmaOnlyEvaluateNode(node);
        return node;
    }

    @Override
    public Object visitScript(CluCalcParser.ScriptContext ctx) {
        this.graphBuilder = new GraphBuilder();
        this.graph = this.graphBuilder.getGraph();
        this.nodes = new ArrayList();
        super.visitScript(ctx);
        this.graphBuilder.finish();
        return this.graph;
    }

    @Override
    public Object visitOutputAssignmentCaseC(CluCalcParser.OutputAssignmentCaseCContext ctx) {
        AssignmentNode assignment = (AssignmentNode)this.visit((ParseTree)ctx.val);
        ExpressionStatement ex = this.graphBuilder.processExpressionStatement((Expression)assignment.getVariable());
        if (this.inMacro) {
            this.macroNodes.add((SequentialNode)ex);
        } else {
            this.nodes.add((SequentialNode)ex);
        }
        this.graphBuilder.addVisualizerExpression(ex);
        return null;
    }

    @Override
    public Object visitOutputVariableCaseC(CluCalcParser.OutputVariableCaseCContext ctx) {
        ExpressionStatement ex = this.graphBuilder.processExpressionStatement((Expression)new Variable(ctx.val.getText()));
        if (this.inMacro) {
            this.macroNodes.add((SequentialNode)ex);
        } else {
            this.nodes.add((SequentialNode)ex);
        }
        this.graphBuilder.addVisualizerExpression(ex);
        return ex;
    }

    @Override
    public Object visitOutputAssignmentCaseQ(CluCalcParser.OutputAssignmentCaseQContext ctx) {
        AssignmentNode assignment = (AssignmentNode)this.visit((ParseTree)ctx.val);
        StoreResultNode n2 = this.graphBuilder.handlePrint((Expression)assignment.getVariable().copy());
        if (this.inMacro) {
            this.macroNodes.add((SequentialNode)n2);
        } else {
            this.nodes.add((SequentialNode)n2);
        }
        return null;
    }

    @Override
    public Object visitOutputVariableCaseQ(CluCalcParser.OutputVariableCaseQContext ctx) {
        StoreResultNode node = this.graphBuilder.handlePrint((Expression)new Variable(ctx.val.getText()));
        if (this.inMacro) {
            this.macroNodes.add((SequentialNode)node);
        } else {
            this.nodes.add((SequentialNode)node);
        }
        return node;
    }

    @Override
    public Object visitAssignment(CluCalcParser.AssignmentContext ctx) {
        Variable variable = (Variable)this.visit((ParseTree)ctx.var);
        Expression expression = (Expression)this.visit((ParseTree)ctx.expr);
        if (this.inMacro) {
            AssignmentNode node = new AssignmentNode(this.graph, variable, expression);
            this.macroNodes.add((SequentialNode)node);
            return node;
        }
        return this.graphBuilder.handleAssignment(variable, expression);
    }

    @Override
    public Object visitVariable(CluCalcParser.VariableContext ctx) {
        return this.graphBuilder.processIdentifier(ctx.getText());
    }

    @Override
    public Object visitConstant(CluCalcParser.ConstantContext ctx) {
        return new FloatConstant(Double.parseDouble(ctx.getText()));
    }

    @Override
    public Object visitArgument(CluCalcParser.ArgumentContext ctx) {
        return new FunctionArgument(Integer.parseInt(ctx.index.getText()));
    }

    @Override
    public Object visitDual(CluCalcParser.DualContext ctx) {
        return this.graphBuilder.processFunction("*", Collections.singletonList((Expression)this.visit((ParseTree)ctx.operand)));
    }

    @Override
    public Object visitSingleArgument(CluCalcParser.SingleArgumentContext ctx) {
        LinkedList<Expression> result = new LinkedList<Expression>();
        result.add((Expression)this.visit((ParseTree)ctx.arg));
        return result;
    }

    @Override
    public Object visitMultipleArgument(CluCalcParser.MultipleArgumentContext ctx) {
        LinkedList<Expression> result = new LinkedList<Expression>();
        result.add((Expression)this.visit((ParseTree)ctx.arg));
        result.addAll((LinkedList)this.visit((ParseTree)ctx.nextarg));
        return result;
    }

    @Override
    public Object visitFunction(CluCalcParser.FunctionContext ctx) {
        LinkedList args = ctx.args != null ? (LinkedList)this.visit((ParseTree)ctx.args) : new LinkedList();
        return this.graphBuilder.processFunction(ctx.name.getText(), args);
    }

    @Override
    public Object visitCOLORARGS(CluCalcParser.COLORARGSContext ctx) {
        LinkedList args = ctx.args != null ? (LinkedList)this.visit((ParseTree)ctx.args) : new LinkedList();
        this.nodes.add((SequentialNode)this.graphBuilder.handleColor(args));
        return null;
    }

    @Override
    public Object visitBgcolor(CluCalcParser.BgcolorContext ctx) {
        LinkedList args = ctx.args != null ? (LinkedList)this.visit((ParseTree)ctx.args) : new LinkedList();
        this.graphBuilder.handleBGColor(args);
        return null;
    }

    @Override
    public Object visitMACRO(CluCalcParser.MACROContext ctx) {
        if (this.inMacro) {
            throw new ParserError("A macro may only be defined in global scope.");
        }
        this.graphBuilder.beginNewScope();
        this.inMacro = true;
        this.macroNodes = new LinkedList();
        this.graphBuilder.addMacroName(ctx.id.getText());
        if (ctx.body != null) {
            this.visit((ParseTree)ctx.body);
        }
        Expression e = null;
        if (ctx.e != null) {
            e = (Expression)this.visit((ParseTree)ctx.e);
        }
        this.graphBuilder.handleMacroDefinition(ctx.id.getText(), this.macroNodes, e);
        this.graphBuilder.endNewScope();
        this.inMacro = false;
        return null;
    }

    @Override
    public Object visitAddition(CluCalcParser.AdditionContext ctx) {
        Expression l = (Expression)this.visit((ParseTree)ctx.left);
        Expression r = (Expression)this.visit((ParseTree)ctx.right);
        return new Addition(l, r);
    }

    @Override
    public Object visitSubtraction(CluCalcParser.SubtractionContext ctx) {
        return new Subtraction((Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public Object visitMultiplication(CluCalcParser.MultiplicationContext ctx) {
        return new Multiplication((Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public Object visitDivision(CluCalcParser.DivisionContext ctx) {
        return new Division((Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public Object visitOuterProduct(CluCalcParser.OuterProductContext ctx) {
        return new OuterProduct((Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public Object visitInnerProduct(CluCalcParser.InnerProductContext ctx) {
        return new InnerProduct((Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public Object visitNegation(CluCalcParser.NegationContext ctx) {
        return new Negation((Expression)this.visit((ParseTree)ctx.operand));
    }

    @Override
    public Object visitReverse(CluCalcParser.ReverseContext ctx) {
        return new Reverse((Expression)this.visit((ParseTree)ctx.operand));
    }

    @Override
    public Object visitBracket(CluCalcParser.BracketContext ctx) {
        return (Expression)this.visit((ParseTree)ctx.e);
    }

    @Override
    public Object visitNegationBracket(CluCalcParser.NegationBracketContext ctx) {
        return new Negation((Expression)this.visit((ParseTree)ctx.operand));
    }

    @Override
    public Object visitCOLORNAME(CluCalcParser.COLORNAMEContext ctx) {
        this.nodes.add((SequentialNode)this.graphBuilder.handleColor(ctx.name.getText()));
        return null;
    }

    @Override
    public Object visitNegationFunction(CluCalcParser.NegationFunctionContext ctx) {
        LinkedList args = ctx.args != null ? (LinkedList)this.visit((ParseTree)ctx.args) : new LinkedList();
        return new Negation(this.graphBuilder.processFunction(ctx.name.getText(), args));
    }

    private static final class ParserError
    extends Error {
        public ParserError(String message) {
            super("Parser error: " + message);
        }
    }
}

