/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.clucalc.input;

import de.gaalop.CheckGAVisitor;
import de.gaalop.UsedVariablesVisitor;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.Node;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.SetCallerVisitor;
import de.gaalop.cfg.Slider;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.cfg.VariableScope;
import de.gaalop.clucalc.input.CluCalcFileHeader;
import de.gaalop.clucalc.input.NullSpace;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.Variable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GraphBuilder {
    private final Map<String, ColorNode> COLORS;
    private static final Map<String, String> illegalNames = new HashMap<String, String>();
    final ControlFlowGraph graph;
    private SequentialNode lastNode;
    private CluCalcFileHeader header;
    private boolean setMode = false;
    private Set<String> macros = new HashSet<String>();
    private String currentMacroDefinition;
    private VariableScope currentScope = VariableScope.GLOBAL;

    public void beginNewScope() {
        this.currentScope = new VariableScope(this.currentScope);
    }

    public void endNewScope() {
        this.currentScope = this.currentScope.getParent();
    }

    public GraphBuilder() {
        this.graph = new ControlFlowGraph();
        this.lastNode = this.graph.getStartNode();
        this.COLORS = new HashMap<String, ColorNode>();
        this.COLORS.put("Black", this.getRBGColor(0.0, 0.0, 0.0));
        this.COLORS.put("Blue", this.getRBGColor(0.0, 0.0, 1.0));
        this.COLORS.put("Cyan", this.getRBGColor(0.0, 1.0, 1.0));
        this.COLORS.put("Green", this.getRBGColor(0.0, 1.0, 0.0));
        this.COLORS.put("Magenta", this.getRBGColor(1.0, 0.0, 1.0));
        this.COLORS.put("Orange", this.getRBGColor(1.0, 0.7f, 0.0));
        this.COLORS.put("Red", this.getRBGColor(1.0, 0.0, 0.0));
        this.COLORS.put("White", this.getRBGColor(1.0, 1.0, 1.0));
        this.COLORS.put("Yellow", this.getRBGColor(1.0, 1.0, 0.0));
        this.header = CluCalcFileHeader.get(this.graph.getStartNode());
        if (this.header == null) {
            this.header = new CluCalcFileHeader(this.graph.getStartNode());
        }
    }

    public void addPragmaOutputVariable(String variable) {
        this.graph.addPragmaOutputVariable(variable);
    }

    public void addPragmaMinMaxValues(String variable, String min, String max) {
        this.graph.addPragmaMinMaxValues(variable, min, max);
    }

    private void addNode(SequentialNode node) {
        this.lastNode.insertAfter(node);
        this.lastNode = node;
    }

    public ControlFlowGraph getGraph() {
        return this.graph;
    }

    public AssignmentNode handleAssignment(Variable variable, Expression expression) {
        this.checkIllegalVariable(variable);
        CheckGAVisitor gaVisitor = new CheckGAVisitor();
        expression.accept((ExpressionVisitor)gaVisitor);
        if (gaVisitor.isGA()) {
            gaVisitor.addGAVariable(variable);
        }
        AssignmentNode assignment = new AssignmentNode(this.graph, variable, expression);
        this.addNode((SequentialNode)assignment);
        return assignment;
    }

    void checkIllegalVariable(Variable variable) {
        String name = variable.getName();
        String reason = illegalNames.get(name);
        if (reason != null) {
            throw new IllegalArgumentException("Illegal variable name '" + name + "' (" + reason + "). Please use another variable.");
        }
    }

    public void handleNullSpace(NullSpace ns) {
        this.header.setNullSpace(ns);
    }

    public StoreResultNode handlePrint(Expression variable) {
        if (variable instanceof Variable) {
            StoreResultNode storeResult = new StoreResultNode(this.graph, (Variable)variable);
            this.addNode((SequentialNode)storeResult);
            return storeResult;
        }
        throw new IllegalArgumentException("Only variables can be marked for optimization.");
    }

    public IfThenElseNode handleIfStatement(Expression condition, List<SequentialNode> then_part, List<SequentialNode> else_part) {
        IfThenElseNode ifthenelse = new IfThenElseNode(this.graph, condition);
        this.addNode((SequentialNode)ifthenelse);
        this.rewireNodes(then_part, (SequentialNode)ifthenelse);
        this.rewireNodes(else_part, (SequentialNode)ifthenelse);
        ifthenelse.setPositive(then_part.get(0));
        ifthenelse.setNegative((SequentialNode)(else_part != null && else_part.size() > 0 ? else_part.get(0) : new BlockEndNode(this.graph, (SequentialNode)ifthenelse)));
        return ifthenelse;
    }

    public LoopNode handleLoop(List<SequentialNode> body, String iterations) {
        LoopNode loop = new LoopNode(this.graph);
        this.addNode((SequentialNode)loop);
        this.rewireNodes(body, (SequentialNode)loop);
        loop.setBody((SequentialNode)(body != null && body.size() > 0 ? body.get(0) : new BlockEndNode(this.graph, (SequentialNode)loop)));
        if (iterations != null) {
            loop.setIterations(Integer.parseInt(iterations));
        }
        return loop;
    }

    public BreakNode handleBreak() {
        BreakNode brk = new BreakNode(this.graph);
        this.addNode((SequentialNode)brk);
        return brk;
    }

    public void handleSlider(Variable var, String label, double min, double max, double step, double init) {
        Slider slider = new Slider(var, label, min, max, step, init);
        this.graph.addInputVariable(var);
        this.graph.addSlider(slider);
    }

    public ColorNode handleColor(List<Expression> args) {
        ColorNode color = this.getRGBAColor(args);
        this.addNode((SequentialNode)color);
        return color;
    }

    public ColorNode handleColor(String name) {
        ColorNode color = (ColorNode)this.COLORS.get(name).copy();
        if (color == null) {
            throw new IllegalArgumentException("Color " + name + " is not known.");
        }
        this.addNode((SequentialNode)color);
        return color;
    }

    public void handleBGColor(List<Expression> args) {
        this.graph.setBGColor(this.getRGBAColor(args));
    }

    private ColorNode getRGBAColor(List<Expression> args) {
        if (args.size() < 3) {
            throw new IllegalArgumentException("Argument must have 3 values for R, G and B");
        }
        Expression r = args.get(0);
        Expression g = args.get(1);
        Expression b = args.get(2);
        Expression alpha = args.size() == 4 ? args.get(3) : null;
        ColorNode color = alpha == null ? new ColorNode(this.graph, r, g, b) : new ColorNode(this.graph, r, g, b, alpha);
        return color;
    }

    private ColorNode getRBGColor(double r, double g, double b) {
        return new ColorNode(this.graph, (Expression)new FloatConstant(r), (Expression)new FloatConstant(g), (Expression)new FloatConstant(b));
    }

    public Macro handleMacroDefinition(String id, List<SequentialNode> body, Expression ret) {
        this.currentMacroDefinition = "";
        Macro macro = new Macro(this.graph, id, body, ret);
        this.addNode((SequentialNode)macro);
        this.graph.addMacro(macro);
        return macro;
    }

    public void addMacroName(String name) {
        this.macros.add(name);
        this.currentMacroDefinition = name;
    }

    private void rewireNodes(List<SequentialNode> list, SequentialNode base) {
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator<SequentialNode> it = list.iterator();
        SequentialNode current = it.next();
        this.graph.removeNode(current);
        current.addPredecessor((Node)base);
        while (it.hasNext()) {
            SequentialNode next = it.next();
            this.graph.removeNode(next);
            current.replaceSuccessor(current.getSuccessor(), (Node)next);
            next.addPredecessor((Node)current);
            current = next;
        }
        current.replaceSuccessor(current.getSuccessor(), (Node)new BlockEndNode(this.graph, base));
    }

    public Expression processIdentifier(String name) {
        Variable v = new Variable(name);
        this.currentScope.addVariable(v);
        return v;
    }

    public Expression processFunction(String name, List<Expression> args) {
        return new MacroCall(name, args);
    }

    public ExpressionStatement processExpressionStatement(Expression e) {
        ExpressionStatement statement = new ExpressionStatement(this.graph, e);
        this.addNode((SequentialNode)statement);
        return statement;
    }

    public void addVisualizerExpression(ExpressionStatement expr) {
        this.graph.visualizerExpressions.add(expr);
    }

    public void finish() {
        SetCallerVisitor visitor = new SetCallerVisitor();
        this.graph.accept((ControlFlowVisitor)visitor);
        SetLocalAndInputVariables inputFinder = new SetLocalAndInputVariables();
        this.graph.accept((ControlFlowVisitor)inputFinder);
    }

    static {
        illegalNames.put("length", "protected in Maxima");
    }

    private class SetLocalAndInputVariables
    implements ControlFlowVisitor {
        SetLocalAndInputVariables() {
        }

        private void findUndeclaredVariables(Expression expression) {
            UsedVariablesVisitor visitor = new UsedVariablesVisitor();
            expression.accept((ExpressionVisitor)visitor);
            for (Variable usedVariable : visitor.getVariables()) {
                GraphBuilder.this.checkIllegalVariable(usedVariable);
                if (GraphBuilder.this.graph.getLocalVariables().contains(usedVariable)) continue;
                if (GraphBuilder.this.graph.getPragmaMinValue().containsKey(usedVariable.getName())) {
                    usedVariable.setMinValue((String)GraphBuilder.this.graph.getPragmaMinValue().get(usedVariable.getName()));
                }
                if (GraphBuilder.this.graph.getPragmaMaxValue().containsKey(usedVariable.getName())) {
                    usedVariable.setMaxValue((String)GraphBuilder.this.graph.getPragmaMaxValue().get(usedVariable.getName()));
                }
                GraphBuilder.this.graph.addInputVariable(usedVariable);
            }
        }

        public void visit(StartNode node) {
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(AssignmentNode node) {
            this.findUndeclaredVariables(node.getValue());
            GraphBuilder.this.graph.addLocalVariable(node.getVariable());
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(StoreResultNode node) {
            this.findUndeclaredVariables((Expression)node.getValue());
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(IfThenElseNode node) {
            this.findUndeclaredVariables(node.getCondition());
            node.getPositive().accept((ControlFlowVisitor)this);
            node.getNegative().accept((ControlFlowVisitor)this);
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(BlockEndNode node) {
        }

        public void visit(LoopNode node) {
            node.getBody().accept((ControlFlowVisitor)this);
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(BreakNode node) {
        }

        public void visit(Macro node) {
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(ExpressionStatement node) {
            this.findUndeclaredVariables(node.getExpression());
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }

        public void visit(EndNode node) {
        }

        public void visit(ColorNode node) {
            node.getSuccessor().accept((ControlFlowVisitor)this);
        }
    }
}

