/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.clucalc.output;

import de.gaalop.Notifications;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.clucalc.input.CluCalcFileHeader;
import de.gaalop.clucalc.output.DfgVisitor;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CfgVisitor
implements ControlFlowVisitor {
    private static final String MAPLE_SUFFIX = "_opt";
    String codeSuffix;
    private Log log = LogFactory.getLog(CfgVisitor.class);
    private Map<String, Set<Integer>> assignedComponents = new HashMap<String, Set<Integer>>();
    StringBuilder code = new StringBuilder();
    int indent;

    public CfgVisitor(String suffix) {
        this.codeSuffix = suffix;
    }

    public String getCode() {
        return this.code.toString();
    }

    public void visit(StartNode startNode) {
        CluCalcFileHeader header = CluCalcFileHeader.get(startNode);
        if (header != null) {
            if (header.getNullSpace() != null) {
                switch (header.getNullSpace()) {
                    case IPNS: {
                        this.code.append(":IPNS;\n");
                        break;
                    }
                    case OPNS: {
                        this.code.append(":OPNS;\n");
                    }
                }
            }
            this.code.append("\n");
        }
        for (Variable localVariable : startNode.getGraph().getLocalVariables()) {
            this.code.append(localVariable.getName() + this.codeSuffix);
            this.code.append(" = List(");
            this.code.append(startNode.getGraph().getAlgebraDefinitionFile().getBladeCount());
            this.code.append(");\n");
        }
        this.code.append("\n");
        startNode.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(EndNode node) {
    }

    public void visit(AssignmentNode assignmentNode) {
        Set<Integer> assigned = this.assignedComponents.get(assignmentNode.getVariable().getName());
        if (assigned != null && assigned.isEmpty()) {
            String message = "Variable " + assignmentNode.getVariable().getName() + " has been reset for reuse.";
            this.log.warn((Object)message);
            Notifications.addWarning((String)message);
            this.appendIndent();
            this.code.append(assignmentNode.getVariable().getName());
            this.code.append(" = List(32); // reset for reuse\n");
        }
        this.appendIndent();
        this.addCode((Expression)assignmentNode.getVariable());
        this.code.append(" = ");
        this.addCode(assignmentNode.getValue());
        if (assignmentNode.getVariable() instanceof MultivectorComponent) {
            this.code.append("; // ");
            MultivectorComponent component = (MultivectorComponent)assignmentNode.getVariable();
            this.code.append(assignmentNode.getGraph().getBladeString(component));
            this.code.append("\n");
            if (!this.assignedComponents.containsKey(component.getName())) {
                this.assignedComponents.put(component.getName(), new HashSet());
            }
            this.assignedComponents.get(component.getName()).add(component.getBladeIndex());
        } else {
            this.code.append(";\n");
        }
        assignmentNode.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        this.appendIndent();
        this.addCode(node.getExpression());
        this.code.append(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        this.appendIndent();
        this.code.append('?');
        Variable outputVariable = node.getValue();
        String variableName = outputVariable.getName();
        String opt = variableName + MAPLE_SUFFIX;
        this.code.append(variableName);
        Set<Integer> var = this.assignedComponents.get(opt);
        if (var != null) {
            this.code.append(" = ");
            int bladeCount = node.getGraph().getAlgebraDefinitionFile().getBladeCount();
            for (int i = 0; i < bladeCount; ++i) {
                if (!var.contains(i)) continue;
                Expression blade = node.getGraph().getAlgebraDefinitionFile().getBladeExpression(i);
                this.code.append(opt.replace(MAPLE_SUFFIX, this.codeSuffix));
                this.code.append("(");
                this.code.append(i + 1);
                this.code.append(")");
                this.code.append(" * ");
                this.addCode(blade);
                this.code.append(" + ");
            }
            this.code.setLength(this.code.length() - 3);
        }
        this.assignedComponents.put(opt, new HashSet());
        this.code.append(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(IfThenElseNode node) {
        this.code.append('\n');
        this.appendIndent();
        this.code.append("if (");
        this.addCode(node.getCondition());
        this.code.append(") {\n");
        ++this.indent;
        node.getPositive().accept((ControlFlowVisitor)this);
        --this.indent;
        this.appendIndent();
        this.code.append("}");
        if (node.getNegative() instanceof BlockEndNode) {
            this.code.append("\n\n");
        } else {
            this.code.append(" else ");
            boolean isElseIf = false;
            if (node.getNegative() instanceof IfThenElseNode) {
                IfThenElseNode ifthenelse = (IfThenElseNode)node.getNegative();
                isElseIf = ifthenelse.isElseIf();
            }
            if (!isElseIf) {
                this.code.append("{\n");
                ++this.indent;
            }
            node.getNegative().accept((ControlFlowVisitor)this);
            if (!isElseIf) {
                --this.indent;
                this.appendIndent();
                this.code.append("}\n\n");
            }
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(LoopNode node) {
        this.appendIndent();
        this.code.append("loop {\n");
        ++this.indent;
        node.getBody().accept((ControlFlowVisitor)this);
        --this.indent;
        this.appendIndent();
        this.code.append("}\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BreakNode breakNode) {
        this.appendIndent();
        this.code.append("break;\n");
    }

    public void visit(BlockEndNode node) {
    }

    void addCode(Expression value) {
        DfgVisitor visitor = new DfgVisitor(this.codeSuffix, MAPLE_SUFFIX);
        value.accept((ExpressionVisitor)visitor);
        this.code.append(visitor.getCode());
    }

    void appendIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.code.append("\t");
        }
    }

    public void visit(Macro node) {
        throw new IllegalStateException("Macros should have been inlined.");
    }

    public void visit(ColorNode node) {
        this.appendIndent();
        this.code.append(":");
        this.code.append(node);
        this.code.append(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }
}

