/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.clucalc.output;

import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.ConfigurationProperty;
import de.gaalop.clucalc.output.CluCalcCodeGenerator;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Plugin
implements CodeGeneratorPlugin {
    @ConfigurationProperty(type=ConfigurationProperty.Type.TEXT)
    public String suffix = "_opt";
    private Log log = LogFactory.getLog(Plugin.class);
    private Image icon;
    private CluCalcCodeGenerator codeGenerator;

    public Plugin() {
        URL url = this.getClass().getResource("/de/gaalop/clucalc/icon.png");
        if (url != null) {
            try {
                this.icon = ImageIO.read(url);
            }
            catch (IOException e) {
                this.log.error((Object)("Unable to read plugin icon " + url));
            }
        } else {
            this.log.warn((Object)"Unable to find GAALOPScript plugin icon!");
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public CodeGenerator createCodeGenerator() {
        if (this.codeGenerator == null) {
            this.codeGenerator = new CluCalcCodeGenerator(this.suffix);
        }
        this.codeGenerator.setSuffix(this.suffix);
        return this.codeGenerator;
    }

    public String getName() {
        return "GAALOPScript";
    }

    public String getDescription() {
        return "This plugin generates GAALOPScripts.";
    }

    public Image getIcon() {
        return this.icon;
    }
}

