/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gappopencl;

import de.gaalop.DefaultCodeGenerator;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.gappopencl.GAPPMvSizeVisitor;
import de.gaalop.gappopencl.GAPPOpenCLVisitor;
import de.gaalop.gappopencl.Plugin;

public class GAPPOpenCLCodeGenerator
extends DefaultCodeGenerator {
    public static Integer numBlocks = -1;
    public static final String inputsVector = "inputsVector";
    public static final String tempMv = "tempmv";
    public static final String dot = "dot";
    private final Plugin plugin;

    GAPPOpenCLCodeGenerator(Plugin plugin) {
        super("c");
        this.plugin = plugin;
    }

    public static String getVarName(String mvName) {
        if (mvName.startsWith(tempMv) || mvName.startsWith(dot) || mvName.startsWith(inputsVector)) {
            return mvName + "_" + numBlocks;
        }
        return mvName;
    }

    protected String generateCode(ControlFlowGraph in) {
        numBlocks = numBlocks + 1;
        GAPPMvSizeVisitor mvSizeVisitor = new GAPPMvSizeVisitor();
        try {
            in.accept((ControlFlowVisitor)mvSizeVisitor);
        }
        catch (Throwable error) {
            this.plugin.notifyError(error);
        }
        GAPPOpenCLVisitor visitor = new GAPPOpenCLVisitor(mvSizeVisitor.getMvSizes());
        try {
            in.accept((ControlFlowVisitor)visitor);
        }
        catch (Throwable error) {
            this.plugin.notifyError(error);
        }
        return visitor.getCode();
    }
}

