/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gappDebugger;

import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.Notifications;
import de.gaalop.gappDebugger.GappDebugger;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.Observable;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Plugin
extends Observable
implements CodeGeneratorPlugin {
    private Log log = LogFactory.getLog(Plugin.class);
    private Image icon;

    public Plugin() {
        URL url = this.getClass().getResource("icon.png");
        if (url != null) {
            try {
                this.icon = ImageIO.read(url);
            }
            catch (IOException e) {
                this.log.error((Object)("Unable to read plugin icon " + url));
            }
        } else {
            this.log.warn((Object)"Unable to find plugin icon!");
        }
    }

    public CodeGenerator createCodeGenerator() {
        return new GappDebugger();
    }

    public String getName() {
        return "Gapp Debugger";
    }

    public String getDescription() {
        return "This plugin debugs GAPP code.";
    }

    public Image getIcon() {
        return this.icon;
    }

    void notifyError(Throwable error) {
        this.setChanged();
        this.notifyObservers(new Notifications.Error(error));
    }
}

