/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gappDebugger;

import de.gaalop.gapp.PairSetOfVariablesAndIndices;
import de.gaalop.gapp.SetVectorArgument;
import de.gaalop.gapp.instructionSet.GAPPAssignInputsVector;
import de.gaalop.gapp.instructionSet.GAPPAssignMv;
import de.gaalop.gapp.instructionSet.GAPPBaseInstruction;
import de.gaalop.gapp.instructionSet.GAPPCalculateMv;
import de.gaalop.gapp.instructionSet.GAPPCalculateMvCoeff;
import de.gaalop.gapp.instructionSet.GAPPDotVectors;
import de.gaalop.gapp.instructionSet.GAPPResetMv;
import de.gaalop.gapp.instructionSet.GAPPSetMv;
import de.gaalop.gapp.instructionSet.GAPPSetVector;
import de.gaalop.gapp.variables.GAPPMultivector;
import de.gaalop.gapp.variables.GAPPSetOfVariables;
import de.gaalop.gapp.variables.GAPPVector;
import de.gaalop.gapp.visitor.GAPPVisitor;
import java.util.HashSet;
import java.util.LinkedList;

public class SetOfVariablesUpdater
implements GAPPVisitor {
    private HashSet<String> multivectors = new HashSet();
    private HashSet<String> vectors = new HashSet();

    private SetOfVariablesUpdater() {
    }

    public static void updateSetOfVariables(LinkedList<GAPPBaseInstruction> instructions) {
        SetOfVariablesUpdater updater = new SetOfVariablesUpdater();
        for (GAPPBaseInstruction i : instructions) {
            i.accept((GAPPVisitor)updater, null);
        }
    }

    public Object visitAssignMv(GAPPAssignMv gappAssignMv, Object arg) {
        this.multivectors.add(gappAssignMv.getDestination().getName());
        return null;
    }

    public Object visitDotVectors(GAPPDotVectors gappDotVectors, Object arg) {
        this.multivectors.add(gappDotVectors.getDestination().getName());
        return null;
    }

    public Object visitResetMv(GAPPResetMv gappResetMv, Object arg) {
        this.multivectors.add(gappResetMv.getDestination().getName());
        return null;
    }

    public Object visitSetMv(GAPPSetMv gappSetMv, Object arg) {
        String name = gappSetMv.getSource().getName();
        if (this.multivectors.contains(name)) {
            gappSetMv.setSource((GAPPSetOfVariables)new GAPPMultivector(name));
        } else if (this.vectors.contains(name)) {
            gappSetMv.setSource((GAPPSetOfVariables)new GAPPVector(name));
        } else {
            System.err.println("Multivector/Vector " + name + " is not declared!");
        }
        this.multivectors.add(gappSetMv.getDestination().getName());
        return null;
    }

    public Object visitSetVector(GAPPSetVector gappSetVector, Object arg) {
        LinkedList entries = gappSetVector.getEntries();
        for (SetVectorArgument entry : entries) {
            if (entry.isConstant()) continue;
            PairSetOfVariablesAndIndices pair = (PairSetOfVariablesAndIndices)entry;
            String name = pair.getSetOfVariable().getName();
            if (this.multivectors.contains(name)) {
                pair.setSetOfVariable((GAPPSetOfVariables)new GAPPMultivector(name));
                continue;
            }
            if (this.vectors.contains(name)) {
                pair.setSetOfVariable((GAPPSetOfVariables)new GAPPVector(name));
                continue;
            }
            System.err.println("Multivector/Vector " + name + " is not declared!");
        }
        this.vectors.add(gappSetVector.getDestination().getName());
        return null;
    }

    public Object visitCalculateMv(GAPPCalculateMv gappCalculateMv, Object arg) {
        this.multivectors.add(gappCalculateMv.getDestination().getName());
        return null;
    }

    public Object visitCalculateMvCoeff(GAPPCalculateMvCoeff gappCalculateMvCoeff, Object arg) {
        this.multivectors.add(gappCalculateMvCoeff.getDestination().getName());
        return null;
    }

    public Object visitAssignInputsVector(GAPPAssignInputsVector gAPPAssignInputsVector, Object arg) {
        this.vectors.add("inputsVector");
        return null;
    }
}

